/*
 * Decompiled with CFR 0.152.
 */
package jode.expr;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import jode.AssertError;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.CombineableOperator;
import jode.expr.Expression;
import jode.expr.LocalStoreOperator;
import jode.expr.LocalVarOperator;
import jode.expr.MatchableOperator;
import jode.expr.NopOperator;
import jode.type.Type;

public abstract class Operator
extends Expression {
    public static final int ADD_OP = 1;
    public static final int SUB_OP = 2;
    public static final int SHIFT_OP = 6;
    public static final int AND_OP = 9;
    public static final int ASSIGN_OP = 12;
    public static final int OPASSIGN_OP = 12;
    public static final int INC_OP = 24;
    public static final int DEC_OP = 25;
    public static final int COMPARE_OP = 26;
    public static final int EQUALS_OP = 26;
    public static final int NOTEQUALS_OP = 27;
    public static final int LESS_OP = 28;
    public static final int GREATEREQ_OP = 29;
    public static final int GREATER_OP = 30;
    public static final int LESSEQ_OP = 31;
    public static final int LOG_AND_OP = 32;
    public static final int LOG_OR_OP = 33;
    public static final int LOG_NOT_OP = 34;
    public static final int NEG_OP = 36;
    static String[] opString = new String[]{"", " + ", " - ", " * ", " / ", " % ", " << ", " >> ", " >>> ", " & ", " | ", " ^ ", " = ", " += ", " -= ", " *= ", " /= ", " %= ", " <<= ", " >>= ", " >>>= ", " &= ", " |= ", " ^= ", "++", "--", " == ", " != ", " < ", " >= ", " > ", " <= ", " && ", " || ", "!", "~", "-"};
    protected int operatorIndex;
    private int operandcount;
    Expression[] subExpressions;

    public void initOperands(int n) {
        this.operandcount = n;
        this.subExpressions = new Expression[n];
        int n2 = 0;
        while (n2 < n) {
            this.subExpressions[n2] = new NopOperator(Type.tUnknown);
            this.subExpressions[n2].parent = this;
            ++n2;
        }
        this.updateSubTypes();
    }

    public int getFreeOperandCount() {
        return this.operandcount;
    }

    public boolean isFreeOperator() {
        return this.subExpressions.length == 0 || this.subExpressions[this.subExpressions.length - 1] instanceof NopOperator;
    }

    public boolean isFreeOperator(int n) {
        return this.subExpressions.length == n && (n == 0 || this.subExpressions[n - 1] instanceof NopOperator);
    }

    public Expression addOperand(Expression expression) {
        int n = this.subExpressions.length;
        while (n-- > 0) {
            int n2 = this.subExpressions[n].getFreeOperandCount();
            if (n2 <= 0) continue;
            this.subExpressions[n] = this.subExpressions[n].addOperand(expression);
            this.operandcount += this.subExpressions[n].getFreeOperandCount() - n2;
            this.updateType();
            return this;
        }
        throw new AssertError("addOperand called, but no operand needed");
    }

    public Operator getOperator() {
        return this;
    }

    public Expression[] getSubExpressions() {
        return this.subExpressions;
    }

    public void setSubExpressions(int n, Expression expression) {
        int n2 = expression.getFreeOperandCount() - this.subExpressions[n].getFreeOperandCount();
        this.subExpressions[n] = expression;
        expression.parent = this;
        Operator operator = this;
        while (operator != null) {
            operator.operandcount += n2;
            operator = operator.parent;
        }
        this.updateType();
    }

    public int getOperatorIndex() {
        return this.operatorIndex;
    }

    public void setOperatorIndex(int n) {
        this.operatorIndex = n;
    }

    public String getOperatorString() {
        return opString[this.operatorIndex];
    }

    public boolean opEquals(Operator operator) {
        return this == operator;
    }

    public Expression simplify() {
        int n = 0;
        while (n < this.subExpressions.length) {
            this.subExpressions[n] = this.subExpressions[n].simplify();
            this.subExpressions[n].parent = this;
            ++n;
        }
        return this;
    }

    public void fillInGenSet(Collection collection, Collection collection2) {
        if (this instanceof LocalVarOperator) {
            LocalVarOperator localVarOperator = (LocalVarOperator)this;
            if (localVarOperator.isRead() && collection != null) {
                collection.add(localVarOperator.getLocalInfo());
            }
            if (collection2 != null) {
                collection2.add(localVarOperator.getLocalInfo());
            }
        }
        int n = 0;
        while (n < this.subExpressions.length) {
            this.subExpressions[n].fillInGenSet(collection, collection2);
            ++n;
        }
    }

    public void fillDeclarables(Collection collection) {
        int n = 0;
        while (n < this.subExpressions.length) {
            this.subExpressions[n].fillDeclarables(collection);
            ++n;
        }
    }

    public void makeDeclaration(Set set) {
        int n = 0;
        while (n < this.subExpressions.length) {
            this.subExpressions[n].makeDeclaration(set);
            ++n;
        }
    }

    public boolean hasSideEffects(Expression expression) {
        if (expression instanceof MatchableOperator && expression.containsConflictingLoad((MatchableOperator)((Object)expression))) {
            return true;
        }
        int n = 0;
        while (n < this.subExpressions.length) {
            if (this.subExpressions[n].hasSideEffects(expression)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean containsConflictingLoad(MatchableOperator matchableOperator) {
        if (matchableOperator.matches(this)) {
            return true;
        }
        int n = 0;
        while (n < this.subExpressions.length) {
            if (this.subExpressions[n].containsConflictingLoad(matchableOperator)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean containsMatchingLoad(CombineableOperator combineableOperator) {
        Operator operator = (Operator)((Object)combineableOperator);
        if (combineableOperator.getLValue().matches(this) && this.subsEquals((Operator)((Object)combineableOperator.getLValue()))) {
            return true;
        }
        int n = 0;
        while (n < this.subExpressions.length) {
            if (this.subExpressions[n].containsMatchingLoad(combineableOperator)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int canCombine(CombineableOperator combineableOperator) {
        if (combineableOperator.getLValue() instanceof LocalStoreOperator && ((Operator)((Object)combineableOperator)).getFreeOperandCount() == 0) {
            int n = 0;
            while (n < this.subExpressions.length) {
                int n2 = this.subExpressions[n].canCombine(combineableOperator);
                if (n2 != 0) {
                    return n2;
                }
                if (this.subExpressions[n].hasSideEffects((Expression)((Object)combineableOperator))) {
                    return -1;
                }
                ++n;
            }
        }
        if (combineableOperator.lvalueMatches(this)) {
            return this.subsEquals((Operator)((Object)combineableOperator)) ? 1 : -1;
        }
        if (this.subExpressions.length > 0) {
            return this.subExpressions[0].canCombine(combineableOperator);
        }
        return 0;
    }

    public Expression combine(CombineableOperator combineableOperator) {
        Operator operator = (Operator)((Object)combineableOperator);
        if (combineableOperator.lvalueMatches(this)) {
            combineableOperator.makeNonVoid();
            operator.parent = this.parent;
            return operator;
        }
        int n = 0;
        while (n < this.subExpressions.length) {
            Expression expression = this.subExpressions[n].combine(combineableOperator);
            if (expression != null) {
                this.subExpressions[n] = expression;
                this.updateType();
                return this;
            }
            ++n;
        }
        return null;
    }

    public boolean subsEquals(Operator operator) {
        if (this == operator) {
            return true;
        }
        if (operator.subExpressions == null) {
            return this.subExpressions == null;
        }
        if (this.subExpressions.length != operator.subExpressions.length) {
            return false;
        }
        int n = 0;
        while (n < this.subExpressions.length) {
            if (!this.subExpressions[n].equals(operator.subExpressions[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Operator)) {
            return false;
        }
        Operator operator = (Operator)object;
        return this.opEquals(operator) && this.subsEquals(operator);
    }

    public boolean isConstant() {
        int n = 0;
        while (n < this.subExpressions.length) {
            if (!this.subExpressions[n].isConstant()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public abstract void dumpExpression(TabbedPrintWriter var1) throws IOException;

    public Operator(Type type) {
        this(type, 0);
    }

    public Operator(Type type, int n) {
        super(type);
        this.operatorIndex = n;
        if (type == null) {
            throw new AssertError("type == null");
        }
    }
}

