/*
 * Decompiled with CFR 0.152.
 */
package com.cycling74.mxjedit;

import com.cycling74.mxjedit.MXJEditCompileContext;
import com.cycling74.mxjedit.MXJEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class MXJEditCfunkCompileFrame
extends JFrame {
    ColorPane messages = null;
    JButton compile_button = null;
    JButton close_button = null;
    private MXJEditCompileContext _ctx = null;
    private CaretListener _error_lineno_dispatch = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            int mark = e.getMark();
            int dot = e.getDot();
            int lineno = -1;
            if (mark != dot) {
                try {
                    ColorPane cp = (ColorPane)e.getSource();
                    lineno = Integer.parseInt(cp.getSelectedText());
                    MXJEditCfunkCompileFrame cf = cp.compile_frame;
                    MXJEditCompileContext ctx = cf.getCompileContext();
                    MXJEditor ed = ctx.getEditor();
                    if (!ed.isVisible()) {
                        ed.setVisible(true);
                    } else {
                        ed.toFront();
                    }
                    ed.selectLine(lineno);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
    };

    public MXJEditCfunkCompileFrame(MXJEditCompileContext ctx) {
        this._ctx = ctx;
        this.messages = new ColorPane(this);
        this.messages.setEditable(false);
        JScrollPane jsp = new JScrollPane(this.messages);
        JPanel ap = new JPanel();
        this.compile_button = new JButton("Compile");
        this.close_button = new JButton("Close");
        this.compile_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        if ((this).MXJEditCfunkCompileFrame.this.compile_button.isEnabled()) {
                            (this).MXJEditCfunkCompileFrame.this.compile_button.setEnabled(false);
                        }
                        MXJEditCfunkCompileFrame.this.do_compile();
                        if (!(this).MXJEditCfunkCompileFrame.this.compile_button.isEnabled()) {
                            (this).MXJEditCfunkCompileFrame.this.compile_button.setEnabled(true);
                        }
                    }
                });
                t.start();
            }
        });
        this.close_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MXJEditCfunkCompileFrame.this.do_close();
            }
        });
        ap.add(this.compile_button);
        ap.add(this.close_button);
        this.getRootPane().setDefaultButton(this.compile_button);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                int keycode = evt.getKeyCode();
                int mod = evt.getModifiers();
                if (keycode == 87 && (mod & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    MXJEditCfunkCompileFrame.this.setVisible(false);
                    MXJEditCfunkCompileFrame.this.dispose();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                int keycode = evt.getKeyCode();
                int mod = evt.getModifiers();
                if (keycode == 69 && (mod & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    MXJEditor e = MXJEditCfunkCompileFrame.this._ctx.getEditor();
                    if (e.isVisible()) {
                        e.toFront();
                    } else {
                        e.setVisible(true);
                    }
                }
            }
        });
        this.getContentPane().add((Component)jsp, "Center");
        this.getContentPane().add((Component)ap, "South");
        this.setTitle("MXJ Funklet Compile Window");
        this.pack();
        this.setSize(750, 320);
        Dimension dim = this.getToolkit().getScreenSize();
        this.setLocation(dim.width / 4, 50);
        this.setVisible(true);
        this.requestFocus();
    }

    public void setCompileContext(MXJEditCompileContext ctx) {
        this._ctx = ctx;
    }

    public MXJEditCompileContext getCompileContext() {
        return this._ctx;
    }

    protected void do_compile() {
        Color ERROR_COLOR = Color.red.darker();
        final Color MESSAGE_COLOR = Color.blue.darker();
        Color OK_COLOR = Color.green.darker();
        this.messages.setEditable(true);
        this.messages.setText(null);
        String sourcefile = this._ctx.getSourceFile();
        File sourcedir = new File(this._ctx.getSourceDirectory());
        if (!sourcedir.exists() || !sourcedir.isDirectory()) {
            this.messages.append(ERROR_COLOR, "sourcedirectory " + sourcedir.getAbsolutePath() + " does not exist or is not a directory");
            return;
        }
        boolean error = false;
        this.setSize(750, 320);
        if (this._ctx.getEditor() != null) {
            this._ctx.getEditor().menu_save();
        }
        try {
            this.messages.removeCaretListener(this._error_lineno_dispatch);
            String[] cmd = new String[]{"make", "-k"};
            String[] env = null;
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd, env, sourcedir);
            InputStream stderr = proc.getErrorStream();
            InputStreamReader isr = new InputStreamReader(stderr);
            BufferedReader br = new BufferedReader(isr);
            final BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            this.messages.append(MESSAGE_COLOR, "Compiling " + sourcefile + ".........\n\n");
            this.messages.append(MESSAGE_COLOR, "executing ");
            for (int i = 0; i < cmd.length; ++i) {
                this.messages.append(MESSAGE_COLOR, cmd[i] + " ");
            }
            this.messages.append(MESSAGE_COLOR, " in directory " + sourcedir.toString());
            this.messages.append(MESSAGE_COLOR, "\n\n");
            Thread t = new Thread(){

                public void run() {
                    try {
                        String line;
                        while ((line = stdout.readLine()) != null) {
                            MXJEditCfunkCompileFrame.this.messages.append(MESSAGE_COLOR, line + "\n");
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            t.start();
            String line = null;
            String err_lineno = null;
            String err_msg = null;
            String err_rest_msg = null;
            int err_count = 0;
            int idx = -1;
            while ((line = br.readLine()) != null) {
                idx = line.indexOf("funk.c");
                if (idx != -1) {
                    ++err_count;
                    int first_col = -1;
                    int second_col = -1;
                    first_col = line.indexOf(58, idx);
                    second_col = line.indexOf(58, first_col + 1);
                    if (first_col == -1 || second_col == -1) {
                        this.messages.append(ERROR_COLOR, line + "\n");
                        continue;
                    }
                    err_msg = line.substring(0, first_col);
                    this.messages.append(ERROR_COLOR, err_msg);
                    err_lineno = line.substring(first_col + 1, second_col);
                    this.messages.append(MESSAGE_COLOR, "[ " + err_lineno + " ]", 14);
                    err_rest_msg = line.substring(second_col + 1);
                    this.messages.append(ERROR_COLOR, err_rest_msg + "\n");
                    continue;
                }
                this.messages.append(ERROR_COLOR, line + "\n");
            }
            String now = DateFormat.getDateTimeInstance().format(new Date());
            int exitVal = proc.waitFor();
            if (exitVal == 0) {
                this.messages.append(OK_COLOR, "0 errors\n");
                this.messages.append(OK_COLOR, "[ " + now + " ]\n");
                this.messages.append(OK_COLOR, " compilation of " + sourcefile + " was successful");
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.setVisible(false);
                this.dispose();
            } else {
                int err_scale = 25;
                this.messages.append(ERROR_COLOR, "[ " + now + " ]\n");
                this.messages.append(ERROR_COLOR, " compilation of " + sourcefile + " failed.");
                this.setSize(this.getWidth(), 320 + err_scale * Math.min(8, err_count));
                this.messages.addCaretListener(this._error_lineno_dispatch);
            }
            proc.destroy();
        }
        catch (Throwable t) {
            this.messages.append(ERROR_COLOR, "Unexpected Error During Compile:\n\n");
            this.messages.append(ERROR_COLOR, "    " + t.getMessage() + "\n\n");
            this.messages.append(ERROR_COLOR, "See Max console for stack trace.\n");
            t.printStackTrace();
        }
        this.messages.setEditable(false);
    }

    private void do_close() {
        this.setVisible(false);
        this.dispose();
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, MXJEditCfunkCompileFrame.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = MXJEditCfunkCompileFrame.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, MXJEditCfunkCompileFrame.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = MXJEditCfunkCompileFrame.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis) {
            this.requestFocus();
            this.getRootPane().setDefaultButton(this.compile_button);
        }
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    class ColorPane
    extends JTextPane {
        public MXJEditCfunkCompileFrame compile_frame = null;

        public ColorPane(MXJEditCfunkCompileFrame compile_frame_) {
            this.compile_frame = compile_frame_;
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    int keycode = evt.getKeyCode();
                    int mod = evt.getModifiers();
                    if (keycode == 87 && (mod & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                        ColorPane.this.compile_frame.setVisible(false);
                        ColorPane.this.compile_frame.dispose();
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    int keycode = evt.getKeyCode();
                    int mod = evt.getModifiers();
                    if (keycode == 69 && (mod & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                        MXJEditor e = MXJEditCfunkCompileFrame.this._ctx.getEditor();
                        if (e.isVisible()) {
                            e.toFront();
                        } else {
                            e.setVisible(true);
                        }
                    }
                }
            });
        }

        public void append(Color c, String s) {
            this.append(c, s, 10);
        }

        public void append(Color c, String s, int fontsize) {
            StyleContext sc = StyleContext.getDefaultStyleContext();
            AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, c);
            aset = sc.addAttribute(aset, StyleConstants.FontFamily, "courier");
            aset = sc.addAttribute(aset, StyleConstants.FontSize, new Integer(fontsize));
            int len = this.getDocument().getLength();
            this.setCaretPosition(len);
            this.setCharacterAttributes(aset, false);
            this.replaceSelection(s);
        }
    }
}

